#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include "boards.h"

// Этот конфигурационный файл содержит основные параметры настройки.
//Расширенные настройки в Configuration_adv.h
//ОСНОВНЫЕ НАСТРОЙКИ ПАРАМЕТРОВ: выберите свой тип платы, тип температурного датчика, масштабирование оси и endstop конфигурацию

//===========================================================================
//============================= DELTA Printer ===============================
//===========================================================================
// Для Delta printer заменяют конфигурационные файлы файлами в каталоге
// example_configurations/delta directory.
//

//===========================================================================
//============================= SCARA Printer ===============================
//===========================================================================
// Для SCARA printer заменяют конфигурационные файлы файлами в каталоге
// example_configurations/SCARA directory.
//

//Определенная пользователями информация о версии этой сборки выводиться на экран во время стартапа [Pronterface, и т.д.]
//Реализованна идея профессором Брэйно

//#define STRING_VERSION "1.0.2"

#define STRING_VERSION_CONFIG_H __DATE__ " " __TIME__ // Создайте дату и время
#define STRING_CONFIG_H_AUTHOR "(none, default config)" // Кто вносил изменения

//SERIAL_PORT выбирает, какой последовательный порт должен использоваться для связи с хостом.
//Это позволяет соединение беспроводных адаптеров (например), к контактам порта не по умолчанию.
//Последовательный порт 0 все еще используется загрузчиком Ардуино независимо от этого урегулирования.
#define SERIAL_PORT 0

// Коммуникационную скорость принтера
#define BAUDRATE 250000

// Последовательный порт, связанный с интерфейсом Bluetooth
//#define BTENABLED              // Включить интерфейс BT на устройствах AT90USB

// Далее выбор электрической платы
// Выберите название из boards.h, которое соответствует вашему устройству
#ifndef MOTHERBOARD 
#define MOTHERBOARD BOARD_RAMPS_13_EFB 
#endif 

// Определяет пользовательское имя для Вашего универсального Менделя
// #define CUSTOM_MENDEL_NAME "This Mendel"

// Установить уникальный идентификатор для этого принтера, (Используемый некоторыми программами, чтобы дифференцироваться между устройствами)
// Вы можете использовать онлайн-сервис, чтобы генерировать случайный UUID. (eg http://www.uuidgenerator.net/version4)
// #define MACHINE_UUID "00000000-0000-0000-0000-000000000000"

// Число экструдеров
#define EXTRUDERS 1

//// Какой источник питания Вы имеете. Выберите тот, который соответствует Вашему устройству
// 1 = ATX
// 2 = X-Box 360 203 Ватт (синий провод соединён с PS_ON, а красный провод к VCC)

#define POWER_SUPPLY 1

// Определяет устройство защиты выключения на старте. Если вы не знаете, что это, просто пропустите
// #define PS_DEFAULT_OFF

//===========================================================================
//=============================Тепловые параметры============================
//===========================================================================
//
//--НОРМАЛЬНАЯ НАГРУЗКА 4.7 кОма! - нагрузка на 1 кОм может использоваться на hotend датчике, используя корректный резистор и стол
//
//// Настройки температурных датчиков:
// -2 термопара MAX6675 (только для датчиков 0)
// -1 термопара AD595
// 0 не используется 
// 1 это 100k терморезистор - лучший выбор для EPCOS 100k (4.7k нагрузки)
// 2 это 200k терморезистор - ATC Semitec 204GT-2 (4.7k нагрузки)
// 3 это Терморезистор Mendel-частей (4.7k нагрузки)
// 4 это 10k терморезистор !! не использовать в hotend. На высоких температурах большое отклонение. !!
// 5 это 100K терморезистор - ATC Semitec 104GT-2 (Использовать в ParCan & J-Head) (4.7k нагрузки)
// 6 это 100k EPCOS - Не такой точный как 1 (4.7k нагрузки)
// 7 это 100k Honeywell терморезистор 135-104LAG-J01 (4.7k нагрузки)
// 71 это 100k Honeywell терморезистор 135-104LAF-J01 (4.7k нагрузки)
// 8 это 100k 0603 SMD Vishay NTCS0603E3104FXT (4.7k нагрузки)
// 9 это 100k GE Sensing AL03006-58.2K-97-G1 (4.7k нагрузки)
// 10 это 100k RS терморезистор 198-961 (4.7k нагрузки)
// 11 это 100k beta 3950 1% терморезистор (4.7k нагрузки)
// 12 это 100k 0603 SMD Vishay NTCS0603E3104FXT (4.7k нагрузки) (калиброванный для подогревательного стола Makibox)
// 13 это 100k Hisens 3950 1% до 300°C для hotend "Simple ONE " и "Hotend "All In ONE" 
// 20 это PT100 схема найдена в Ultimainboard V2.x
// 60 это 100k Maker's Tool Works Kapton Bed терморезистор beta=3950
//
//    1k ohm таблица нагрузки - Это не нормально, Вы, должно быть, изменили Ваш 4.7k на 1k
//                          (но дает большую точность и более стабильный PID)
// 51 это 100k thermistor - EPCOS (1k нагрузки)
// 52 это 200k thermistor - ATC Semitec 204GT-2 (1k нагрузки)
// 55 это 100k thermistor - ATC Semitec 104GT-2 (Используется в ParCan и J-Head) (1k нагрузки)
//
// 1047 это Pt1000 с 4k7 нагрузки
// 1010 это Pt1000 с 1k нагрузки (не стандарт)
// 147 это Pt100 с 4k7 нагрузки
// 110 это Pt100 с 1k нагрузки (не стандарт)

#define TEMP_SENSOR_0 5
#define TEMP_SENSOR_1 0
#define TEMP_SENSOR_2 0
#define TEMP_SENSOR_BED 6

// Температурный датчик 1 избыточный датчик для датчика 0. Если различия температуры в этих датчиках слишком высоко то печать прекратиться.
//#define TEMP_SENSOR_1_AS_REDUNDANT
#define MAX_REDUNDANT_TEMP_SENSOR_DIFF 10

// Фактическая температура должна быть близка к заданной длины перед M109 что бы успешно вернуться.
#define TEMP_RESIDENCY_TIME 10  // (секунды)
#define TEMP_HYSTERESIS 3       // (degC) диапозон +/- рассматриваемая температура "близости" для заданной
#define TEMP_WINDOW     1       // (degC) Окно вокруг заданного таймера degC

// Минимальная температура определяет температуру, ниже которой не включиться нагреватель. Это используется
// для проверки, что проводное соединение к терморезистору не повреждено.
// Иначе это привело бы к нагревателю, включаемому все время.
#define HEATER_0_MINTEMP 170
#define HEATER_1_MINTEMP 5
#define HEATER_2_MINTEMP 5
#define BED_MINTEMP 5

// Когда температура превысит максимальное значение, нагреватель выключиться.
// Эта функция существует, чтобы защитить Ваш hotend от случайного перегрева, но *НЕ* от короткого замыкания терморезистора
// Вы должны использовать MINTEMP для терморезистора.
#define HEATER_0_MAXTEMP 275
#define HEATER_1_MAXTEMP 275
#define HEATER_2_MAXTEMP 275
#define BED_MAXTEMP 150

// Если Ваш стол имеет низкое сопротивление, например 6 Ом, Вы можете уменьшить средний ток.
//Значение должно быть целым числом, и стол подогрева будет включен для 1 интервала из
//Интервалов HEATER_BED_DUTY_CYCLE_DIVIDER.
//#define HEATER_BED_DUTY_CYCLE_DIVIDER 4

// Если Вы хотите, что бы нагреватель M105, сообщал мощность в ваттах, определите BED_WATTS, и (согласуйте со всеми экструдерами) EXTRUDER_WATTS
//#define EXTRUDER_WATTS (12.0*12.0/6.7) //  P=I^2/R
//#define BED_WATTS (12.0*12.0/1.1)      // P=I^2/R

// PID настройки:
// Прокомментируйте следующие строки, чтобы отключить PID и включить bang-bang.
#define PIDTEMP
#define BANG_MAX 255 // номинальные пределы носика, в то время как в режиме bang-bang; 255=полный номинал
#define PID_MAX BANG_MAX // номинальные пределы носика, в то время как PID активен (см. PID_FUNCTIONAL_RANGE ниже); 255=полный текущий
#ifdef PIDTEMP
  //#define PID_DEBUG // Отправляет отладочные данные в последовательный порт.
  //#define PID_OPENLOOP 1 // Помещает PID в разомкнутый цикл. M104/M140 устанавливает выходную мощность от 0 до PID_MAX
  //#define SLOW_PWM_HEATERS // PWM с очень низкой частотой (примерно 0.125Hz=8 с) и минимальным утвержденным временем приблизительно 1 с, полезно для нагревателей управляемых реле
  #define PID_FUNCTIONAL_RANGE 10 // Если разность температур между целевой температурой и фактической температурой
                                  // больше PID_FUNCTIONAL_RANGE тогда, PID будет отключен, и нагреватель будет установлен в мин / макс
  #define PID_INTEGRAL_DRIVE_MAX PID_MAX  //ограничитель для интегральной температуры
  #define K1 0.95 //сглаживание фактора в PID
  #define PID_dT ((OVERSAMPLENR * 10.0)/(F_CPU / 64.0 / 256.0)) //выборка периода температурной подпрограммы

// Если Вы используете предварительно сконфигурированный hotend тогда, Вы можете использовать один из наборов значений, не комментируя его
//Ultimaker
    #define  DEFAULT_Kp 22.2
    #define  DEFAULT_Ki 1.08
    #define  DEFAULT_Kd 114

// MakerGear
//    #define  DEFAULT_Kp 7.0
//    #define  DEFAULT_Ki 0.1
//    #define  DEFAULT_Kd 12

// Mendel Parts V9 на 12V
//    #define  DEFAULT_Kp 63.0
//    #define  DEFAULT_Ki 2.25
//    #define  DEFAULT_Kd 440
#endif // PIDTEMP

// Управление температурой стола
// Выберите PID или bang-bang с PIDTEMPBED. Если bang-bang, BED_LIMIT_SWITCHING включит гистерезис
//
//Раскомментируйте это, чтобы включить PID стола. Здесь используется та же частота PWM в качестве экструдера.
//Если Ваш PID_dT выше - значение по умолчанию, и корректно для Ваших аппаратных средств/конфигурации, использующие 7.689 Гц,
//хорошие для управления прямоугольной волной в активной нагрузке и не значительно влияет на нагревание FET.
//Также хорошо работает на Fotek SSR-10DA Solid State Relay в нагревателе на 250 Вт.
//Если Ваша конфигурация существенно отличается, и Вы не понимаете включенные проблемы, Вы, вероятно,
//не должен использовать PID стол, пока кто-то еще не проверяет Вашу аппаратную работу.
//Если это включено, найдите свои собственные константы PID ниже.
//#define PIDTEMPBED
//
//#define BED_LIMIT_SWITCHING

//Здесь устанавливают макс. питание стола, и заменяет опцию HEATER_BED_DUTY_CYCLE_DIVIDER.
//все формы управления кроватью повинуются этому (PID, bang-bang, bang-bang с гистерезисом)
//любое изменение значения с 255 включает форму PWM стола точно так же, как HEATER_BED_DUTY_CYCLE_DIVIDER,
//таким образом, Вы не должны использовать его, если Вы не согласовали с PWM Вашего стола. (см., что включает комментарий PIDTEMPBED)
#define MAX_BED_POWER 255 // предельный рабочий цикл стола; 255=полный текущий

#ifdef PIDTEMPBED
//120v 250W нагреватель силикона в 4мм боросиликата (MendelMax 1.5+)
//От модели FOPDT - kp=.39 Tp=405 Tdead=66, Tc устанавливают до 79.2, агрессивный фактор .15 (vs .1, 1, 10)
    #define  DEFAULT_bedKp 10.00
    #define  DEFAULT_bedKi .023
    #define  DEFAULT_bedKd 305.4

//120v 250W нагреватель силикона в 4мм боросиликата (MendelMax 1.5+)
//от pidautotune
//    #define  DEFAULT_bedKp 97.1
//    #define  DEFAULT_bedKi 1.41
//    #define  DEFAULT_bedKd 1675.16

// НАЙДИТЕ СВОИ: "M303 E-1 C8 S90" выполнять автоматическую настройку стола в 90 градусах для 8 циклов.
#endif // PIDTEMPBED



//предотвращает опасные перемещения Экструдера, т.е. если температура находится за пределом
//может быть отключен программным обеспечением в любых целях
#define PREVENT_DANGEROUS_EXTRUDE
//если PREVENT_DANGEROUS_EXTRUDE включен, Вы можете все еще отключить (раскомментируйте) очень длинные биты экструзии отдельно.
#define PREVENT_LENGTHY_EXTRUDE

#define EXTRUDE_MINTEMP 170
#define EXTRUDE_MAXLENGTH (X_MAX_LENGTH+Y_MAX_LENGTH) //предотвращает экструзию очень больших расстояний.

/*================== Температурная неконтролируемая защита ==============================
Это - функция,нужна чтобы защитить Ваш принтер от сгорания в сообщениях, 
если он имеет невстроенный терморезистор, 
(это недавно произошло с моим другом и
мотивировало меня написать эту функцию).

Проблема: Если терморезистор оторвется, то он считает более низкую температуру, 
чем фактическая.
Система включит нагреватель навсегда, зажигая нить и что-либо
еще вокруг.

После того, как температура достигает нужной впервые, эта функция начнёт измерять, 
как долго текущая температура остается ниже нужной 
минус _HYSTERESIS (set_temperature - THERMAL_RUNAWAY_PROTECTION_HYSTERESIS).

Если она остается дольше чем _PERIOD, это означает температура терморезистора
не может догнать нужную, таким образом, что-то *может быть* пошло не так. 
Затем система для безопасности отклдючиться.
У Вас не будет проблемы если
Ваш нагрев экструдера занимает 2 минуты, чтобы достигнуть нужной температуры.

*/
//Если Вы хотите активировать эту опцию для всех своих нагревателей экструдера,
//раскомментируйте эти 2 определения ниже:

// Параметры для всех нагревателей экструдера
//#define THERMAL_RUNAWAY_PROTECTION_PERIOD 40 //в секундах
//#define THERMAL_RUNAWAY_PROTECTION_HYSTERESIS 4 // в градусе Цельсия

// Если Вы хотите активировать эту опцию для своего нагревателя стола,
//раскомментируйте эти 2 определения ниже:

// Параметры для нагревателя стола
//#define THERMAL_RUNAWAY_PROTECTION_BED_PERIOD 20 //в секундах
//#define THERMAL_RUNAWAY_PROTECTION_BED_HYSTERESIS 2 // в градусе Цельсия
//===========================================================================


//===========================================================================
//=============================Механическое настройки===========================
//===========================================================================

// Раскомментируйте строки ниже для кинематике CoreXY
// #define COREXY

// основные параметры настройки Endstop
#define ENDSTOPPULLUPS // Прокомментируйте это (используйте //в начале строки), чтобы отключить endstop нагрузочные резисторы

#ifndef ENDSTOPPULLUPS
  // хорошие endstop настройки: Отдельная нагрузка. будет проигнорирован, если ENDSTOPPULLUPS будет включен
  // #define ENDSTOPPULLUP_XMAX
  // #define ENDSTOPPULLUP_YMAX
  // #define ENDSTOPPULLUP_ZMAX
  // #define ENDSTOPPULLUP_XMIN
  // #define ENDSTOPPULLUP_YMIN
  // #define ENDSTOPPULLUP_ZMIN
#endif

#ifdef ENDSTOPPULLUPS
  #define ENDSTOPPULLUP_XMAX
  #define ENDSTOPPULLUP_YMAX
  #define ENDSTOPPULLUP_ZMAX
  #define ENDSTOPPULLUP_XMIN
  #define ENDSTOPPULLUP_YMIN
  #define ENDSTOPPULLUP_ZMIN
#endif

// Нагрузка необходима, если Вы непосредственно соединяете механический endswitch между сигнальными и заземляющими выводами.
const bool X_MIN_ENDSTOP_INVERTING = true; // установите в истину, чтобы инвертировать логику endstop.
const bool Y_MIN_ENDSTOP_INVERTING = true; // установите в истину, чтобы инвертировать логику endstop.
const bool Z_MIN_ENDSTOP_INVERTING = true; // установите в истину, чтобы инвертировать логику endstop.
const bool X_MAX_ENDSTOP_INVERTING = true; // установите в истину, чтобы инвертировать логику endstop.
const bool Y_MAX_ENDSTOP_INVERTING = true; // установите в истину, чтобы инвертировать логику endstop.
const bool Z_MAX_ENDSTOP_INVERTING = true; // установите в истину, чтобы инвертировать логику endstop.
//#define DISABLE_MAX_ENDSTOPS
//#define DISABLE_MIN_ENDSTOPS

// Отключите max endstops для совместимости с endstop проверкой подпрограммы
#if defined(COREXY) && !defined(DISABLE_MAX_ENDSTOPS)
  #define DISABLE_MAX_ENDSTOPS
#endif

// Для Инвертирования Включаюшего Степпера Контакты (Активный Низкий), используют 0, не Инвертирование (Активный Высокий) использует 1
#define X_ENABLE_ON 0
#define Y_ENABLE_ON 0
#define Z_ENABLE_ON 0
#define E_ENABLE_ON 0 // Для всех экструдеров

// Отключает ось, когда она не используется.
#define DISABLE_X false
#define DISABLE_Y false
#define DISABLE_Z false
#define DISABLE_E false // Для всех экструдеров
#define DISABLE_INACTIVE_EXTRUDER true //отключите только неактивные экструдеры и оставляет активный экструдер включенным

#define INVERT_X_DIR true    // для Mendel установить false, для Orca установить true
#define INVERT_Y_DIR false    // для Mendel установить true, для Orca установить false
#define INVERT_Z_DIR true     // для Mendel установить false, для Orca установить true
#define INVERT_E0_DIR false   // для экструдера прямого привода v9 установить true, для приспособленного набора экструдера установить false
#define INVERT_E1_DIR false    // для экструдера прямого привода v9 установить true, для приспособленного набора экструдера установить false
#define INVERT_E2_DIR false   // для экструдера прямого привода v9 установить true, для приспособленного набора экструдера установить false

// ENDSTOP параметры:
// Установить начальную точку бля endstops 1=MAX, -1=MIN
#define X_HOME_DIR -1
#define Y_HOME_DIR -1
#define Z_HOME_DIR -1

#define min_software_endstops true // Если установленно true, то ось не переместиться в координаты меньше, чем HOME_POS.
#define max_software_endstops true  // Если установленно true, то ось не переместится в координаты, больше, чем определенно ниже.

// Пределы перемещения после размещения
#define X_MAX_POS 400
#define X_MIN_POS 0
#define Y_MAX_POS 205
#define Y_MIN_POS 0
#define Z_MAX_POS 200
#define Z_MIN_POS 0

#define X_MAX_LENGTH (X_MAX_POS - X_MIN_POS)
#define Y_MAX_LENGTH (Y_MAX_POS - Y_MIN_POS)
#define Z_MAX_LENGTH (Z_MAX_POS - Z_MIN_POS)
//============================= Автовыравнивание стола ===========================

//#define ENABLE_AUTO_BED_LEVELING // Удалите комментарий, чтобы включить (удалите //в начале строки),
#define Z_PROBE_REPEATABILITY_TEST  // Если раскомментировать, тест Воспроизводимости Z-зонда будет включен, когда Auto Bed Leveling включиться.

#ifdef ENABLE_AUTO_BED_LEVELING

// Есть 2 различных способа выбрать X и расположения Y:

//  - режим "сетки"
//Зондируйте каждую точку в прямоугольной сетке
//Вы должны определить прямоугольник и плотность демонстрационных точек
//Этот режим предпочтен, потому что есть больше измерений.
//Раньше вызывалось командой ACCURATE_BED_LEVELING, но "сетка" более дескриптивная

//-Режим "с 3 точками"
//Зондируйте 3 произвольных точки на столе (которые не коллинеарны),
//Вы должны определить X и Y координаты всех 3-х точек

  #define AUTO_BED_LEVELING_GRID
  // с AUTO_BED_LEVELING_GRID стол выбирается в
  // Сетке AUTO_BED_LEVELING_GRID_POINTSxAUTO_BED_LEVELING_GRID_POINTS
  // и решение расчитанно методом наименьших квадратов
  // Примечание: эта функция занимает 10'206 байтов
  #ifdef AUTO_BED_LEVELING_GRID

    //установите прямоугольник, в котором можно зондировать
    #define LEFT_PROBE_BED_POSITION 15
    #define RIGHT_PROBE_BED_POSITION 170
    #define BACK_PROBE_BED_POSITION 180
    #define FRONT_PROBE_BED_POSITION 20

     //определите количество точек сетки измерений
     //Я не вижу оснований, чтобы выйти за предел 3 (=9 точек зондирования на столе)
    #define AUTO_BED_LEVELING_GRID_POINTS 2


  #else  // не AUTO_BED_LEVELING_GRID
    //без сетки просто зондируйте 3 произвольных точки. Простое векторное произведение
    //используется для esimate плоскости печатного стола

      #define ABL_PROBE_PT_1_X 15
      #define ABL_PROBE_PT_1_Y 180
      #define ABL_PROBE_PT_2_X 15
      #define ABL_PROBE_PT_2_Y 20
      #define ABL_PROBE_PT_3_X 170
      #define ABL_PROBE_PT_3_Y 20

  #endif // AUTO_BED_LEVELING_GRID


  // это смещения к щупу относительно наконечника экструдера (Hotend - щуп)
  //X и Y смещения должны быть целые числа
  #define X_PROBE_OFFSET_FROM_EXTRUDER -25
  #define Y_PROBE_OFFSET_FROM_EXTRUDER -29
  #define Z_PROBE_OFFSET_FROM_EXTRUDER -12.35

  #define Z_RAISE_BEFORE_HOMING 4       // (в мм) Увеличте значение Z прежде, чем разместить (G28) для тестового зазора.
                                        // Убедитесь, что у Вас есть это расстояние по Вашему Z_MAX_POS.
                                        
  #define XY_TRAVEL_SPEED 8000         // X и Y скорость перемещения Оси между зазорами, в мм/минуте

  #define Z_RAISE_BEFORE_PROBING 15    //Насколько экструдер поднимиться выше прежде, чем переместиться в первую точку зазора.
  #define Z_RAISE_BETWEEN_PROBINGS 5  //Насколько экструдер поднимиться выше прежде, чем переместиться из-за следующих точек зозора.
  
  //#define Z_PROBE_SLED // включите, если Вам смонтировали z-зазор разработанный Чарльзом Беллом
  //#define SLED_DOCKING_OFFSET 5 // дополнительное расстояние Ось X. 0 хорошо подойдет, но Вы можете продвинуть её далее, если Вы хотите.

  //Тестовый сервомотор будет включен только во время перемещения и затем выключен, чтобы избежать толчка
  //Значение задержки выключить сервомотор, после включения - зависит от скорости сервомотора; 300 мс - хорошее значение, но Вы можете попробовать ниже.
  //Вам НУЖНО ОПРЕДЕЛИТЬ SERVO_ENDSTOPS, чтобы использовать здесь значение выше, чем нуль иначе, Ваш код не скомпилирует.

//  #define PROBE_SERVO_DEACTIVATION_DELAY 300


//Если Вы включили автовыравнивание стола и используете тот же Z зазор для размещения Z,
//настоятельно рекомендовано Вам, включите Z_SAFE_HOMING!!!

  #define Z_SAFE_HOMING   // Эта функция предназначается, чтобы избежать Z, размещающего с зазором вне области стола.
                          // When defined, it will:
                          //-Позволит размещаться Z только после размещения X и Y  И драйверы степпера всё еще включены
                          //-Если тайм-аут драйверов степпера, это будет нужно для X и Y, размещения снова перед Z размещением
                          //-Расположение зазора в определенной точки XY перед размещением Z, размещая всю ось (G28)
                          //-Блокируют Z размещение только, когда зазор выходит за внешнюю облать стола.
  #ifdef Z_SAFE_HOMING

    #define Z_SAFE_HOMING_X_POINT (X_MAX_LENGTH/2)    // Точка X для размещения Z, размещая всю ось (G28)
    #define Z_SAFE_HOMING_Y_POINT (Y_MAX_LENGTH/2)    // Точка Y для размещения Z, размещая всю ось (G28)

  #endif

  #ifdef AUTO_BED_LEVELING_GRID	// Проверка, больше ли Probe_Offset * Grid Points, чем диапазон зазора
    #if X_PROBE_OFFSET_FROM_EXTRUDER < 0
      #if (-(X_PROBE_OFFSET_FROM_EXTRUDER * AUTO_BED_LEVELING_GRID_POINTS) >= (RIGHT_PROBE_BED_POSITION - LEFT_PROBE_BED_POSITION))
	     #error "The X axis probing range is not enough to fit all the points defined in AUTO_BED_LEVELING_GRID_POINTS"
	  #endif
	#else
      #if ((X_PROBE_OFFSET_FROM_EXTRUDER * AUTO_BED_LEVELING_GRID_POINTS) >= (RIGHT_PROBE_BED_POSITION - LEFT_PROBE_BED_POSITION))
	     #error "The X axis probing range is not enough to fit all the points defined in AUTO_BED_LEVELING_GRID_POINTS"
	  #endif
	#endif
    #if Y_PROBE_OFFSET_FROM_EXTRUDER < 0
      #if (-(Y_PROBE_OFFSET_FROM_EXTRUDER * AUTO_BED_LEVELING_GRID_POINTS) >= (BACK_PROBE_BED_POSITION - FRONT_PROBE_BED_POSITION))
	     #error "The Y axis probing range is not enough to fit all the points defined in AUTO_BED_LEVELING_GRID_POINTS"
	  #endif
	#else
      #if ((Y_PROBE_OFFSET_FROM_EXTRUDER * AUTO_BED_LEVELING_GRID_POINTS) >= (BACK_PROBE_BED_POSITION - FRONT_PROBE_BED_POSITION))
	     #error "The Y axis probing range is not enough to fit all the points defined in AUTO_BED_LEVELING_GRID_POINTS"
	  #endif
	#endif

	
  #endif
  
#endif // ENABLE_AUTO_BED_LEVELING


// Расположение переключателей размещения
//#define MANUAL_HOME_POSITIONS  // MANUAL_ * _ HOME_POS ниже будет использоваться
//#define BED_CENTER_AT_0_0  // Центр стола в (X=0, Y=0)

//Ручное расположение переключателей размещения
// Для deltabots это устанавливает вершину и центр Декартовой системы координат
#define MANUAL_X_HOME_POS 0
#define MANUAL_Y_HOME_POS 0
#define MANUAL_Z_HOME_POS 0
//#define MANUAL_Z_HOME_POS 402 // Для Delta: Расстояние между носиком и поверхностью печати после размещения.

// ПАРАМЕТРЫ НАСТРОЙКИ ОСЕЙ ПЕРЕМЕЩЕНИЯ
#define NUM_AXIS 4 // Порядок осей в массиве X, Y, Z, E
#define HOMING_FEEDRATE {50*60, 50*60, 4*60, 0}  // настройка скорости размещения (мм/минута)

// настройки по умолчанию

#define DEFAULT_AXIS_STEPS_PER_UNIT   {78.7402,78.7402,200.0*8/3,760*1.1}  // шаги по умолчанию для Ultimaker
#define DEFAULT_MAX_FEEDRATE          {500, 500, 5, 25}    // (мм/сек)
#define DEFAULT_MAX_ACCELERATION      {9000,9000,100,10000}    // X, Y, Z, E максимальная скорость запуска для ускоренного движения. E значения по умолчанию хорошо для Skeinforge 40 +, поскольку более старые версии повышают их на много.

#define DEFAULT_ACCELERATION          3000    // X, Y, Z и E max ускорение в mm/s^2 для движения печати
#define DEFAULT_RETRACT_ACCELERATION  3000   // X, Y, Z и E max ускорение в mm/s^2 для втягивания

//Смещение экструдеров (раскомментируйте, если используете больше чем один экструдер и полаетесь на встроенное микропрограммное обеспечение).
//Смещение должно быть X=0, Y=0 для экструдера 0 hotend (экструдер по умолчанию).
//Для другого hotends это - их расстояние от экструдера 0 hotend.
// #define EXTRUDER_OFFSET_X {0.0, 20.00} // (в мм) для каждого экструдера, смещения hotend на Оси X
// #define EXTRUDER_OFFSET_Y {0.0, 5.00}  // (в мм) для каждого экструдера, смещения hotend на Оси Y

// Изменение скорости, которое не требует ускорения (т.е. программное обеспечение может принять мгновенно)
#define DEFAULT_XYJERK                20.0    // (мм/сек)
#define DEFAULT_ZJERK                 0.4     // (мм/сек)
#define DEFAULT_EJERK                 5.0    //  (мм/сек)

//===========================================================================
//=============================Дополнительные функции===========================
//===========================================================================

// М код
#define CUSTOM_M_CODES
#ifdef CUSTOM_M_CODES
  #define CUSTOM_M_CODE_SET_Z_PROBE_OFFSET 851
  #define Z_PROBE_OFFSET_RANGE_MIN -15
  #define Z_PROBE_OFFSET_RANGE_MAX -5
#endif


// EEPROM
// Микроконтроллер может сохранить параметры настройки в EEPROM, например, макс. скорость...
// M500 - параметры хранилища EEPROM
// M501 - параметры чтения из EEPROM ( если вам надо сбросить их после того, как Вы изменили их временно).
// M502 - возвратиться к "заводским настройкам" по умолчанию. Вам все еще надо сохранить их в EEPROM.
//включает поддержку EEPROM
//#define EEPROM_SETTINGS
//чтобы отключить Последовательные ответы EEPROM и уменьшить программное пространство  до ~1700 байтов: прокомментируйте это:
// пожалуйста оставьте включенным если можете
//#define EEPROM_CHITCHAT

// Константы подогрева
#define PLA_PREHEAT_HOTEND_TEMP 180
#define PLA_PREHEAT_HPB_TEMP 70
#define PLA_PREHEAT_FAN_SPEED 255   // Введите значение от 0 до 255

#define ABS_PREHEAT_HOTEND_TEMP 240
#define ABS_PREHEAT_HPB_TEMP 100
#define ABS_PREHEAT_FAN_SPEED 255   // Введите значение от 0 до 255

//Жидкокристаллический дисплей и поддержка SD
#define ULTRA_LCD  //общая жидкокристаллическая поддержка, такие как 16x2
//#define DOGLCD  // Поддержка жидкокристаллического дисплея SPI 128x64 (Контроллер семьи графического дисплея ST7565R)
#define SDSUPPORT // Включите поддержку SD-карты в аппаратной консоли
//#define SDSLOW // Исполование более медленного режима передачи SD (обычно не нужно - раскомментарий, если Вы получаете init ошибку)
//#define SD_CHECK_AND_RETRY // Используется проверка CRC и повторение на коммуникации SD
//#define ENCODER_PULSES_PER_STEP 1 // Увеличьтесь, если у Вас есть кодер высокого разрешения
//#define ENCODER_STEPS_PER_MENU_ITEM 5 // Установите согласно ENCODER_PULSES_PER_STEP или как вам нравиться
//#define ULTIMAKERCONTROLLER //как на интернет-магазине Ultimaker.
#define ULTIPANEL  //UltiPanel как на Thingiverse
//#define LCD_FEEDBACK_FREQUENCY_HZ 1000	// это - тональная частота игры зуммера обратной связи пользовательского интерфейса. т.е. Экранный Клик
//#define LCD_FEEDBACK_FREQUENCY_DURATION_MS 100 // продолжительность игры зуммера обратной связи звука пользовательского интерфейса. т.е. Экранный Клик

// Makr-панель MaKr3d с графическим контроллером и поддержкой SD
// http://reprap.org/wiki/MaKr3d_MaKrPanel
//#define MAKRPANEL

// RepRapDiscount умный контроллер (белый PCB)
// http://reprap.org/wiki/RepRapDiscount_Smart_Controller
#define REPRAP_DISCOUNT_SMART_CONTROLLER

// Контроллер GADGETS3D G3D жидкокристаллического дисплея/SD (синий PCB)
// http://reprap.org/wiki/RAMPS_1.3/1.4_GADGETS3D_Shield_with_Panel
//#define G3D_PANEL

// RepRapDiscount ПОЛНЫЙ ГРАФИЧЕСКИЙ Умный Контроллер (квадратичный белый PCB)
// http://reprap.org/wiki/RepRapDiscount_Full_Graphic_Smart_Controller
//
// ==> НЕ ЗАБУДЬТЕ УСТАНОВИТЬ U8glib в Вашей папку библиотеки ARDUINO: http://code.google.com/p/u8glib/wiki/u8glib
//#define REPRAP_DISCOUNT_FULL_GRAPHIC_SMART_CONTROLLER

// The RepRapWorld REPRAPWORLD_KEYPAD v1.1
// http://reprapworld.com/?products_details&products_id=202&cPath=1591_1626
//#define REPRAPWORLD_KEYPAD
//#define REPRAPWORLD_KEYPAD_MOVE_STEP 10.0 // how much should be moved when a key is pressed, eg 10.0 means 10mm per click

// The Elefu RA панель управления
// http://www.elefu.com/index.php?route=product/product&product_id=53
// НЕ ЗАБУДЬТЕ УСТАНОВИТЬ LiquidCrystal_I2C.h в свою папку библиотеки ARDUINO: https://github.com/kiyoshigawa/LiquidCrystal_I2C
//#define RA_CONTROL_PANEL

//автоматическое расширение
#if defined (MAKRPANEL)
 #define DOGLCD
 #define SDSUPPORT
 #define ULTIPANEL
 #define NEWPANEL
 #define DEFAULT_LCD_CONTRAST 17
#endif

#if defined (REPRAP_DISCOUNT_FULL_GRAPHIC_SMART_CONTROLLER)
 #define DOGLCD
 #define U8GLIB_ST7920
 #define REPRAP_DISCOUNT_SMART_CONTROLLER
#endif

#if defined(ULTIMAKERCONTROLLER) || defined(REPRAP_DISCOUNT_SMART_CONTROLLER) || defined(G3D_PANEL)
 #define ULTIPANEL
 #define NEWPANEL
#endif

#if defined(REPRAPWORLD_KEYPAD)
  #define NEWPANEL
  #define ULTIPANEL
#endif
#if defined(RA_CONTROL_PANEL)
 #define ULTIPANEL
 #define NEWPANEL
 #define LCD_I2C_TYPE_PCA8574
 #define LCD_I2C_ADDRESS 0x27   // Адрес I2C расширителя порта
#endif

//ПАНЕЛИ I2C

//#define LCD_I2C_SAINSMART_YWROBOT
#ifdef LCD_I2C_SAINSMART_YWROBOT
  // Пользуйтесь этой библиотекой LiquidCrystal_I2C ( https://bitbucket.org/fmalpartida/new-liquidcrystal/wiki/Home )
  // Удостоверьтесь, что она помещенна в каталог библиотек Ардуино.
  #define LCD_I2C_TYPE_PCF8575
  #define LCD_I2C_ADDRESS 0x27   // Адрес I2C расширителя порта
  #define NEWPANEL
  #define ULTIPANEL
#endif

// Жидкокристаллический дисплей PANELOLU2 с LED, разделенными входами ввода и энкодера
//#define LCD_I2C_PANELOLU2
#ifdef LCD_I2C_PANELOLU2
  // Используется библиотека LiquidTWI2 v1.2.3 или ниже ( https://github.com/lincomatic/LiquidTWI2 )
  // Удостоверьтесь, что каталог LiquidTWI2 помещен в подкаталог библиотек Arduino или Sketchbook.
  // (v1.2.3 выше не требуется, чтобы определить PANELOLU в файле библиотеки LiquidTWI2.h)
  // Примечание: Ввод энкодера PANELOLU2 может или быть непосредственно соединен с контактом
  //       (если BTN_ENC, определен как ! =-1) или читается через I2C (как BTN_ENC ==-1).
  #define LCD_I2C_TYPE_MCP23017
  #define LCD_I2C_ADDRESS 0x20 // Адрес I2C расширителя порта
  #define LCD_USE_I2C_BUZZER //прокомментируйте, чтобы отключить зуммер на жидкокристаллическом дисплее
  #define NEWPANEL
  #define ULTIPANEL

  #ifndef ENCODER_PULSES_PER_STEP
	#define ENCODER_PULSES_PER_STEP 4
  #endif

  #ifndef ENCODER_STEPS_PER_MENU_ITEM
	#define ENCODER_STEPS_PER_MENU_ITEM 1
  #endif


  #ifdef LCD_USE_I2C_BUZZER
	#define LCD_FEEDBACK_FREQUENCY_HZ 1000
	#define LCD_FEEDBACK_FREQUENCY_DURATION_MS 100
  #endif

#endif

// Panucatt VIKI жидкокристаллический дисплей с LED, интегрированным кликом и кнопками L/R/U/P, раздельными входами энкодера
//#define LCD_I2C_VIKI
#ifdef LCD_I2C_VIKI
  // Используется библиотекой LiquidTWI2 v1.2.3 или ниже ( https://github.com/lincomatic/LiquidTWI2 )
  // Удостоверьтесь, что каталог LiquidTWI2 помещен в подкаталог библиотек Arduino или Sketchbook.
  // Примечание: Контакты кнопки LCD паузы/стоп/продолжить должен быть соединен с Arduino
  //       Контакт BTN_ENC (или BTN_ENC к-1, если не используется)
  #define LCD_I2C_TYPE_MCP23017
  #define LCD_I2C_ADDRESS 0x20 // Адрес I2C расширителя порта
  #define LCD_USE_I2C_BUZZER //прокомментируйте, чтобы отключить зуммер на жидкокристаллическом дисплее (требуется LiquidTWI2 v1.2.3 или ниже),
  #define NEWPANEL
  #define ULTIPANEL
#endif

// Панели сдвигов регистра
// ---------------------
// 2 провода, Нефиксирующие жидкокристаллический SR от:
// https://bitbucket.org/fmalpartida/new-liquidcrystal/wiki/schematics#!shiftregister-connection 

//#define SAV_3DLCD
#ifdef SAV_3DLCD
   #define SR_LCD_2W_NL    // Не фиксируя 2 провода shiftregister
   #define NEWPANEL
   #define ULTIPANEL
#endif


#ifdef ULTIPANEL
//  #define NEWPANEL  //включите это, если у Вас есть панель клик-экнодера
  #define SDSUPPORT
  #define ULTRA_LCD
  #ifdef DOGLCD // Измените число линий, чтобы соответствовать графическому дисплею DOG
    #define LCD_WIDTH 20
    #define LCD_HEIGHT 5
  #else
    #define LCD_WIDTH 20
    #define LCD_HEIGHT 4
  #endif
#else //без панели. Просто жидкокристаллический дисплей
  #ifdef ULTRA_LCD
  #ifdef DOGLCD // Измените число линий, чтобы соответствовать 128x64 графическому дисплею
    #define LCD_WIDTH 20
    #define LCD_HEIGHT 5
  #else
    #define LCD_WIDTH 16
    #define LCD_HEIGHT 2
  #endif
  #endif
#endif

// жидкокристаллический контраст по умолчанию для подобных dogm жидкокристаллических дисплеев
#ifdef DOGLCD
# ifndef DEFAULT_LCD_CONTRAST
#  define DEFAULT_LCD_CONTRAST 32
# endif
#endif

// Увеличьте частоту FAN pwm. Удаляет шум PWM, но увеличивает, нагревание в FET/Arduino
//#define FAST_PWM_FAN

// Температурное состояние LED, которые выводят на экран hotend и температуру.
// Если все hotends и температура стола и установленная температура  < 54C тогда, СИНИЙ светодиод включен.
// В другом случае КРАСНЫЙ светодиод включен. 1C гистерезиса.
//#define TEMP_STAT_LEDS

//Используйте программное обеспечение PWM, чтобы управлять вентилятором для нагревателей. Они использует очень низкую частоту
//которая не является столь же раздражающей как с аппаратными средствами PWM. С другой стороны, если эта частота
//слишком низкая, Вы должны также постепенно увеличить SOFT_PWM_SCALE.
//#define FAN_SOFT_PWM

//Постепенное увеличение этой 1 удвоит частоту программного обеспечения PWM,
//влияет на нагреватели и вентилятор, если FAN_SOFT_PWM включен.
//Однако управление разрешением, будет разделено на два для каждого инкремента;
//в нулевом значении есть 128 эффективных позиций управления.
#define SOFT_PWM_SCALE 0

// Триггеры M240 камеры эмуляции удаленной Canon RC 1
// Данные от: http://www.doc-diy.net/photo/rc-1_hacked/
// #define PHOTOGRAPH_PIN     23

// SF отправляет неправильные g-коды дуги при использовании Точки Дуги как процедуры сопряжения
//#define SF_ARC_FIX

// Поддержка экструдера BariCUDA.
//#define BARICUDA

//Поддержка BlinkM/CyzRgb
//#define BLINKM

/*********************************************************************\
* R/C SERVO поддержка 
* Спонсиремая TrinityLabs, переделанная codexmas
**********************************************************************/

// Число сервомоторов
//
// Если Вы выберете конфигурацию ниже, то она получит значение по умолчанию и не должна быть установлена вручную
//установите её вручную, если Вы имеете больше сервомоторов, чем экструдеров и хотите вручную управлять некоторыми
//пропуск или определение как 0 отключит подсистему сервомотора
//Если не уверенный, удаление комментирования / отключенние
//
//#define NUM_SERVOS 3 // Индекс сервомотора запускается с 0 до M280 команды

// Сервомотор Endstops
//
//Допускается приводить в действие endstops сервомотора, в основном использованные для оси Z, чтобы устранить калибровку или изменения высоты стола.
//Используйте команду M206, чтобы исправить смещение высоты переключателя к фактической высоте сопла. Сохраните настройки с M500.
//
//#define SERVO_ENDSTOPS {-1, -1, 0} // Индекс сервомотора для X, Y, Z. Отключается с -1
//#define SERVO_ENDSTOP_ANGLES {0,0, 0,0, 70,0} // X, Y, Z оси расширяют и втягивают углы

/**********************************************************************\
 * Поддержка датчика диаметра нити
 * Также позволяет корректировку диаметра во время печати (
 * Единственный экструдер только в этой точке (экструдер 0)
 * 
 * системные платы
 * 34 - RAMPS1.4 - использует Аналоговый вход 5 на соединителе AUX2 
 * 81 - Printrboard - Аналоговый вход Использования 2 на соединителе Exp1 (версия B, C, D, E)
 * 301 - Rambo - использует Аналоговый вход 3
 * Примечание может потребовать, чтобы аналоговые контакты были определены для различных системных плат
 **********************************************************************/
// Раскомментируйте ниже чтобы включить
//#define FILAMENT_SENSOR

#define FILAMENT_SENSOR_EXTRUDER_NUM	0  //Число экструдеров, у которых есть датчик нити (0,1,2)
#define MEASUREMENT_DELAY_CM			14  //измерительная задержка cm. Это - расстояние от датчика нити до середины барреля

#define DEFAULT_NOMINAL_FILAMENT_DIA  3.0  //Введите диаметр (в мм) нити, обычно используемой (3.0 мм или 1.75 мм) - потом это используется в программном обеспечении slicer. Используется для проверки допустимости чтения датчика
#define MEASURED_UPPER_LIMIT          3.30  //фактор верхнего предела используется для проверки допустимости чтения датчика в мм
#define MEASURED_LOWER_LIMIT          1.90  //фактор нижнего предела для проверки допустимости чтения датчика в мм
#define MAX_MEASUREMENT_DELAY			20  //задержка размер буфера в байтах (1 байт = 1 см) - ограничивает максимальную измерительную допустимую задержку (должно быть больше, чем MEASUREMENT_DELAY_CM и более низкое число сохраняется в оперативную память)

//Определяет использование в коде
#define DEFAULT_MEASURED_FILAMENT_DIA  DEFAULT_NOMINAL_FILAMENT_DIA  //установите измеренный первоначально в номинал 

//При использовании жидкокристаллического дисплея раскомментируйте строчку ниже, чтобы вывести на экран данные датчика Нити на последней строке вместо состояния. Состояние появится в течение 5 секунд.
//#define FILAMENT_LCD_DISPLAY






#include "Configuration_adv.h"
#include "thermistortables.h"

#endif //__CONFIGURATION_H
