#ifndef CONFIGURATION_ADV_H
#define CONFIGURATION_ADV_H

//======================================================================================
//=============================Настройки тепловых параметров============================
//======================================================================================

#ifdef BED_LIMIT_SWITCHING
  #define BED_HYSTERESIS 2 //отключение нагревания только, если T>target+BED_HYSTERESIS и включение нагревания, если T>target-BED_HYSTERESIS
#endif
#define BED_CHECK_INTERVAL 5000 //мс между проверками управления bang-bang

//// Тест нагрева
//Наблюдения в течение периода в миллисекундах каждый раз, когда M104 или M109 увеличивают целевую температуру
//Если температура не увеличилась в конце того периода,целевая температура обнуляется.
//Она может быть сброшено другим M104/M109. Эта проверка инициируется только если целевая температура и текущая температура
//отличаются, по крайней мере, 2x WATCH_TEMP_INCREASE
//#define WATCH_TEMP_PERIOD 40000 //40 секунж
//#define WATCH_TEMP_INCREASE 10  //Подогреть по крайней мере 10 градусов за 20 секунд

#ifdef PIDTEMP
  // это добавляет экспериментальное дополнительное условие к нагревающемуся питанию, пропорциональному скорости экструзии.
  // если Kc выбран хорошо, дополнительное требуемое питание из-за увеличенного расплавления должно быть компенсировано.
  #define PID_ADD_EXTRUSION_RATE
  #ifdef PID_ADD_EXTRUSION_RATE
    #define  DEFAULT_Kc (1) //нагревание power=Kc* (e_speed)
  #endif
#endif


//автоматическая температура: горячая целевая температура конца вычислена всеми буферизированными сериями gcode.
//Максимальные буферизированные шаги/секунда двигателя экструдера вызывают "se".
//Вы вводите автовтемпературный режим M109 S<mintemp> B<maxtemp> F<factor>
//Целевая температура установлена в mintemp+factor*se [шаги/секунда] и ограничена mintemp и maxtemp
// Вы выходите из значения любым M109 без F*
// Кроме того, если температура установлена в значение <mintemp, это не изменяется автотемпературным файлом.
// на Ultimaker начальное тестирование работало с M109 S215 B260 F1 в start.gcode
#define AUTOTEMP
#ifdef AUTOTEMP
  #define AUTOTEMP_OLDWEIGHT 0.98
#endif

//Показать Температурное значение ADC
//Возврат команды M105, помимо основной информации, значение ADC читается из температурных датчиков.
//#define SHOW_TEMP_ADC_VALUES

//  предотвращение выхода экструдера.
//если машина неактивна, и температура выше MINTEMP, каждые несколько секунд немного нити выдавливается
//#define EXTRUDER_RUNOUT_PREVENT
#define EXTRUDER_RUNOUT_MINTEMP 190
#define EXTRUDER_RUNOUT_SECONDS 30.
#define EXTRUDER_RUNOUT_ESTEPS 14. //нить мм
#define EXTRUDER_RUNOUT_SPEED 1500.  //скорость выдавливания
#define EXTRUDER_RUNOUT_EXTRUDE 100

//Эти определения помогают откалибровать датчик AD595 в случае, если Вы получаете неправильные измерения температуры.
//Измеренная температура определена как "actualTemp = (measuredTemp * TEMP_SENSOR_AD595_GAIN) + TEMP_SENSOR_AD595_OFFSET"
#define TEMP_SENSOR_AD595_OFFSET 0.0
#define TEMP_SENSOR_AD595_GAIN   1.0

//Это для управления вентилятором охлаждения драйверов степпера
//включается, когда любой драйвер будет включен
//и выключается после суммы набора секунд из последнего драйвера, отключаемого снова
#define CONTROLLERFAN_PIN -1 //Контакт, используемый для вентилятора, чтобы охладить контроллер (-1, чтобы отключить)
#define CONTROLLERFAN_SECS 60 //Сколько секунд, после того, как все двигатели были отключены, вентилятор должен работать
#define CONTROLLERFAN_SPEED 255  // == максимальная скорость


//#define FAN_KICKSTART_TIME 100

// Вентиляторы экструдера
// Сконфигурируйте выводы контакта вентилятора, чтобы автоматически включать - выключать когда
// температура экструдера выше/ниже EXTRUDER_AUTO_FAN_TEMPERATURE.
// Многократные экструдеры могут быть присвоены тому же контакту. 
// Вентилятор включиться, когда любой выбранный экструдер будет выше порога.
#define EXTRUDER_0_AUTO_FAN_PIN   -1
#define EXTRUDER_1_AUTO_FAN_PIN   -1
#define EXTRUDER_2_AUTO_FAN_PIN   -1
#define EXTRUDER_AUTO_FAN_TEMPERATURE 50
#define EXTRUDER_AUTO_FAN_SPEED   255  // == максимальная скорость


//==============================================================================
//=============================Механические настройки===========================
//==============================================================================

#define ENDSTOPS_ONLY_FOR_HOMING // endstops будет использоваться только для размещения


//// АВТОУСТАНОВКА РАСПОЛОЖЕНИЯ ПРЕДЕЛЬНЫХ ПЕРЕКЛЮЧАТЕЛЕЙ
//// Добавлено by ZetaPhoenix 09-15-2012
#ifdef MANUAL_HOME_POSITIONS  // Используйте ручные предельные расположения переключателя
  #define X_HOME_POS MANUAL_X_HOME_POS
  #define Y_HOME_POS MANUAL_Y_HOME_POS
  #define Z_HOME_POS MANUAL_Z_HOME_POS
#else //Установите мин / макс. позиции переключателя размещения, основанные на размещении направления и пределов перемещения мин / макс. 
  //Ось X
  #if X_HOME_DIR == -1
    #ifdef BED_CENTER_AT_0_0
      #define X_HOME_POS X_MAX_LENGTH * -0.5
    #else
      #define X_HOME_POS X_MIN_POS
    #endif //BED_CENTER_AT_0_0
  #else
    #ifdef BED_CENTER_AT_0_0
      #define X_HOME_POS X_MAX_LENGTH * 0.5
    #else
      #define X_HOME_POS X_MAX_POS
    #endif //BED_CENTER_AT_0_0
  #endif //X_HOME_DIR == -1

  //Ось Y
  #if Y_HOME_DIR == -1
    #ifdef BED_CENTER_AT_0_0
      #define Y_HOME_POS Y_MAX_LENGTH * -0.5
    #else
      #define Y_HOME_POS Y_MIN_POS
    #endif //BED_CENTER_AT_0_0
  #else
    #ifdef BED_CENTER_AT_0_0
      #define Y_HOME_POS Y_MAX_LENGTH * 0.5
    #else
      #define Y_HOME_POS Y_MAX_POS
    #endif //BED_CENTER_AT_0_0
  #endif //Y_HOME_DIR == -1

  // Ось Z
  #if Z_HOME_DIR == -1 //BED_CENTER_AT_0_0 не используется
    #define Z_HOME_POS Z_MIN_POS
  #else
    #define Z_HOME_POS Z_MAX_POS
  #endif //Z_HOME_DIR == -1
#endif 

//#define Z_LATE_ENABLE // Включить Z в последний момент. Необходимо, если Ваш драйвер Z перегревается.

// Единственный драйвер степпера Z обычно используется, чтобы управлять 2 шаговыми двигателями.
// раскомментируйте, это определяет использование отдельных драйверов степпера для каждого двигателя оси Z.
// Только несколько системных плат поддерживают это, как RAMPS, у которых есть двойная поддержка экструдера (2-ой, часто неиспользуемый, драйвер экструдера используется для
// управлять 2-м шаговым двигателем оси Z). Контакты в настоящее время только определены для системные платы RAPMS.
// На RAPMS (или других 5 драйверов) системной плате, используют  функцию ограничения для использованием 1 экструдера.
//#define Z_DUAL_STEPPER_DRIVERS

#ifdef Z_DUAL_STEPPER_DRIVERS
  #undef EXTRUDERS
  #define EXTRUDERS 1
#endif

// То же самое снова, но для Оси Y.
//#define Y_DUAL_STEPPER_DRIVERS

// Определите, если два драйвера Y должны вращаться в противоположных направлениях
#define INVERT_Y2_VS_Y_DIR true

#ifdef Y_DUAL_STEPPER_DRIVERS
  #undef EXTRUDERS
  #define EXTRUDERS 1
#endif

#if defined (Z_DUAL_STEPPER_DRIVERS) && defined (Y_DUAL_STEPPER_DRIVERS)
  #error "You cannot have dual drivers for both Y and Z"
#endif

//#define DUAL_X_CARRIAGE
#ifdef DUAL_X_CARRIAGE
// Конфигурации 2-го X-carriage
// Примечание: Первый x-carriage определяется как the x-carriage который размещает к минимуму endstop;
// второй x-carriage всегда размещает к максимуму endstop.
#define X2_MIN_POS 80     // установите минимум, чтобы гарантировать, что вторая x-carriage не задевает первую
#define X2_MAX_POS 353    // установите максимум в расстояние между toolheads, когда оба датчика будут размещены
#define X2_HOME_DIR 1     // вторая X-carriage всегда размещает к максимуму endstop 
#define X2_HOME_POS X2_MAX_POS // исходное положение по умолчанию - максимальная позиция
    // Однако: В этом режиме значение EXTRUDER_OFFSET_X для второго экструдера обеспечивает программное обеспечение
    // переопределите X2_HOME_POS. Это также позволяет перекалибровать расстояние между двумя endstops
    // не изменяя встроенное микропрограммное обеспечение (посредством команды "M218 T1 X?").
    // Помните: Вы должны установить второе x-смещение экструдера в 0 в Вашем slicer.

// Контакты для второго драйвера степпера x-carriage  (определенны здесь, чтобы избежать дальнейшего усложнения pins.h)
#define X2_ENABLE_PIN 29
#define X2_STEP_PIN 25
#define X2_DIR_PIN 23

// Есть несколько выбираемых режимов перемещения для двойных x-carriages, используя <режим> M605 S
//    Режим 0: Полный контроль. Slicer имеет полный контроль над обеими x-carriages и может достигнуть оптимальных результатов перемещения
//                           так долго пока это поддерживает двойные x-carriages. (M605 S0)
//    Режим 1: Автопаркировачный режим. Встроенное микропрограммное обеспечение будет автоматически парковать и распарковать X-carriages с изменением инструмента так
//                           что дополнительная поддержка slicer не требуется. (M605 S1)
//    Режим 2: Режим дублирования. Встроенное микропрограммное обеспечение прозрачно делает вторую x-carriage, и экструдер копируют все
//                           действия первой x-carriage. Это позволяет принтеру распечатывать 2 произвольных элемента в
//                           один раз. (2-й экструдер x смещение и временное смещение установлен, используя: M605 S2 [Xnnn] [Rmmm])
// Это - режим включения питания по умолчанию, который может позже использовать M605.
#define DEFAULT_DUAL_X_CARRIAGE_MODE 0

// Поскольку x-carriages независимы, мы можем объяснить любое относительное смещение Z
#define EXTRUDER1_Z_OFFSET 0.0           // z offset relative to extruder 0

// Default settings in "Auto-park Mode"
#define TOOLCHANGE_PARK_ZLIFT   0.2      // the distance to raise Z axis when parking an extruder
#define TOOLCHANGE_UNPARK_ZLIFT 1        // the distance to raise Z axis when unparking an extruder

// Default x offset in duplication mode (typically set to half print bed width)
#define DEFAULT_DUPLICATION_X_OFFSET 100

#endif //DUAL_X_CARRIAGE

//homing hits the endstop, then retracts by this distance, before it tries to slowly bump again:
#define X_HOME_RETRACT_MM 5
#define Y_HOME_RETRACT_MM 5
#define Z_HOME_RETRACT_MM 2
//#define QUICK_HOME  //if this is defined, if both x and y are to be homed, a diagonal move will be performed initially.

#define AXIS_RELATIVE_MODES {false, false, false, false}
#ifdef CONFIG_STEPPERS_TOSHIBA
#define MAX_STEP_FREQUENCY 10000 // Max step frequency for Toshiba Stepper Controllers
#else
#define MAX_STEP_FREQUENCY 40000 // Max step frequency for Ultimaker (5000 pps / half step)
#endif
//By default pololu step drivers require an active high signal. However, some high power drivers require an active low signal as step.
#define INVERT_X_STEP_PIN false
#define INVERT_Y_STEP_PIN false
#define INVERT_Z_STEP_PIN false
#define INVERT_E_STEP_PIN false

//default stepper release if idle
#define DEFAULT_STEPPER_DEACTIVE_TIME 60

#define DEFAULT_MINIMUMFEEDRATE       0.0     // minimum feedrate
#define DEFAULT_MINTRAVELFEEDRATE     0.0

// Feedrates for manual moves along X, Y, Z, E from panel
#ifdef ULTIPANEL
#define MANUAL_FEEDRATE {50*60, 50*60, 4*60, 60}  // set the speeds for manual moves (mm/min)
#endif

//Comment to disable setting feedrate multiplier via encoder
#ifdef ULTIPANEL
    #define ULTIPANEL_FEEDMULTIPLY
#endif

// minimum time in microseconds that a movement needs to take if the buffer is emptied.
#define DEFAULT_MINSEGMENTTIME        20000

// If defined the movements slow down when the look ahead buffer is only half full
#define SLOWDOWN

// Frequency limit
// See nophead's blog for more info
// Not working O
//#define XY_FREQUENCY_LIMIT  15

// Minimum planner junction speed. Sets the default minimum speed the planner plans for at the end
// of the buffer and all stops. This should not be much greater than zero and should only be changed
// if unwanted behavior is observed on a user's machine when running at very slow speeds.
#define MINIMUM_PLANNER_SPEED 0.05// (mm/sec)

// MS1 MS2 Stepper Driver Microstepping mode table
#define MICROSTEP1 LOW,LOW
#define MICROSTEP2 HIGH,LOW
#define MICROSTEP4 LOW,HIGH
#define MICROSTEP8 HIGH,HIGH
#define MICROSTEP16 HIGH,HIGH

// Microstep setting (Only functional when stepper driver microstep pins are connected to MCU.
#define MICROSTEP_MODES {16,16,16,16,16} // [1,2,4,8,16]

// Motor Current setting (Only functional when motor driver current ref pins are connected to a digital trimpot on supported boards)
#define DIGIPOT_MOTOR_CURRENT {135,135,135,135,135} // Values 0-255 (RAMBO 135 = ~0.75A, 185 = ~1A)

// uncomment to enable an I2C based DIGIPOT like on the Azteeg X3 Pro
//#define DIGIPOT_I2C
// Number of channels available for I2C digipot, For Azteeg X3 Pro we have 8
#define DIGIPOT_I2C_NUM_CHANNELS 8
// actual motor currents in Amps, need as many here as DIGIPOT_I2C_NUM_CHANNELS
#define DIGIPOT_I2C_MOTOR_CURRENTS {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}

//==============================================================================
//=============================Дополнительные функции===========================
//==============================================================================

//#define CHDK 4        //Pin for triggering CHDK to take a picture see how to use it here http://captain-slow.dk/2014/03/09/3d-printing-timelapses/
#define CHDK_DELAY 50 //How long in ms the pin should stay HIGH before going LOW again

#define SD_FINISHED_STEPPERRELEASE true  //if sd support and the file is finished: disable steppers?
#define SD_FINISHED_RELEASECOMMAND "M84 X Y Z E" // You might want to keep the z enabled so your bed stays in place.

#define SDCARD_RATHERRECENTFIRST  //reverse file order of sd card menu display. Its sorted practically after the file system block order.
// if a file is deleted, it frees a block. hence, the order is not purely chronological. To still have auto0.g accessible, there is again the option to do that.
// using:
//#define MENU_ADDAUTOSTART

// Show a progress bar on the LCD when printing from SD?
//#define LCD_PROGRESS_BAR

#ifdef LCD_PROGRESS_BAR
  // Amount of time (ms) to show the bar
  #define PROGRESS_BAR_BAR_TIME 2000
  // Amount of time (ms) to show the status message
  #define PROGRESS_BAR_MSG_TIME 3000
  // Amount of time (ms) to retain the status message (0=forever)
  #define PROGRESS_MSG_EXPIRE   0
  // Enable this to show messages for MSG_TIME then hide them
  //#define PROGRESS_MSG_ONCE
#endif

// The hardware watchdog should reset the microcontroller disabling all outputs, in case the firmware gets stuck and doesn't do temperature regulation.
#define USE_WATCHDOG

#ifdef USE_WATCHDOG
// If you have a watchdog reboot in an ArduinoMega2560 then the device will hang forever, as a watchdog reset will leave the watchdog on.
// The "WATCHDOG_RESET_MANUAL" goes around this by not using the hardware reset.
//  However, THIS FEATURE IS UNSAFE!, as it will only work if interrupts are disabled. And the code could hang in an interrupt routine with interrupts disabled.
//#define WATCHDOG_RESET_MANUAL
#endif

// Enable the option to stop SD printing when hitting and endstops, needs to be enabled from the LCD menu when this option is enabled.
//#define ABORT_ON_ENDSTOP_HIT_FEATURE_ENABLED

// Babystepping enables the user to control the axis in tiny amounts, independently from the normal printing process
// it can e.g. be used to change z-positions in the print startup phase in real-time
// does not respect endstops!
//#define BABYSTEPPING
#ifdef BABYSTEPPING
  #define BABYSTEP_XY  //not only z, but also XY in the menu. more clutter, more functions
  #define BABYSTEP_INVERT_Z false  //true for inverse movements in Z
  #define BABYSTEP_Z_MULTIPLICATOR 2 //faster z movements

  #ifdef COREXY
    #error BABYSTEPPING not implemented for COREXY yet.
  #endif

  #ifdef DELTA
    #ifdef BABYSTEP_XY
      #error BABYSTEPPING only implemented for Z axis on deltabots.
    #endif
  #endif
#endif

// extruder advance constant (s2/mm3)
//
// advance (steps) = STEPS_PER_CUBIC_MM_E * EXTRUDER_ADVANCE_K * cubic mm per second ^ 2
//
// Hooke's law says:		force = k * distance
// Bernoulli's principle says:	v ^ 2 / 2 + g . h + pressure / density = constant
// so: v ^ 2 is proportional to number of steps we advance the extruder
//#define ADVANCE

#ifdef ADVANCE
  #define EXTRUDER_ADVANCE_K .0

  #define D_FILAMENT 2.85
  #define STEPS_MM_E 836
  #define EXTRUSION_AREA (0.25 * D_FILAMENT * D_FILAMENT * 3.14159)
  #define STEPS_PER_CUBIC_MM_E (axis_steps_per_unit[E_AXIS]/ EXTRUSION_AREA)

#endif // ADVANCE

// Arc interpretation settings:
#define MM_PER_ARC_SEGMENT 1
#define N_ARC_CORRECTION 25

const unsigned int dropsegments=5; //everything with less than this number of steps will be ignored as move and joined with the next movement

// If you are using a RAMPS board or cheap E-bay purchased boards that do not detect when an SD card is inserted
// You can get round this by connecting a push button or single throw switch to the pin defined as SDCARDCARDDETECT
// in the pins.h file.  When using a push button pulling the pin to ground this will need inverted.  This setting should
// be commented out otherwise
#define SDCARDDETECTINVERTED

#ifdef ULTIPANEL
 #undef SDCARDDETECTINVERTED
#endif

// Power Signal Control Definitions
// By default use ATX definition
#ifndef POWER_SUPPLY
  #define POWER_SUPPLY 1
#endif
// 1 = ATX
#if (POWER_SUPPLY == 1)
  #define PS_ON_AWAKE  LOW
  #define PS_ON_ASLEEP HIGH
#endif
// 2 = X-Box 360 203W
#if (POWER_SUPPLY == 2)
  #define PS_ON_AWAKE  HIGH
  #define PS_ON_ASLEEP LOW
#endif

// Control heater 0 and heater 1 in parallel.
//#define HEATERS_PARALLEL

//==============================================================
//=============================Буфер============================
//==============================================================

// The number of linear motions that can be in the plan at any give time.
// THE BLOCK_BUFFER_SIZE NEEDS TO BE A POWER OF 2, i.g. 8,16,32 because shifts and ors are used to do the ring-buffering.
#if defined SDSUPPORT
  #define BLOCK_BUFFER_SIZE 16   // SD,LCD,Buttons take more memory, block buffer needs to be smaller
#else
  #define BLOCK_BUFFER_SIZE 16 // maximize block buffer
#endif


//The ASCII buffer for receiving from the serial:
#define MAX_CMD_SIZE 96
#define BUFSIZE 4


// Firmware based and LCD controlled retract
// M207 and M208 can be used to define parameters for the retraction.
// The retraction can be called by the slicer using G10 and G11
// until then, intended retractions can be detected by moves that only extrude and the direction.
// the moves are than replaced by the firmware controlled ones.

// #define FWRETRACT  //ONLY PARTIALLY TESTED
#ifdef FWRETRACT
  #define MIN_RETRACT 0.1                //minimum extruded mm to accept a automatic gcode retraction attempt
  #define RETRACT_LENGTH 3               //default retract length (positive mm)
  #define RETRACT_LENGTH_SWAP 13         //default swap retract length (positive mm), for extruder change
  #define RETRACT_FEEDRATE 45            //default feedrate for retracting (mm/s)
  #define RETRACT_ZLIFT 0                //default retract Z-lift
  #define RETRACT_RECOVER_LENGTH 0       //default additional recover length (mm, added to retract length when recovering)
  #define RETRACT_RECOVER_LENGTH_SWAP 0  //default additional swap recover length (mm, added to retract length when recovering from extruder change)
  #define RETRACT_RECOVER_FEEDRATE 8     //default feedrate for recovering from retraction (mm/s)
#endif

//adds support for experimental filament exchange support M600; requires display
#ifdef ULTIPANEL
  #define FILAMENTCHANGEENABLE
  #ifdef FILAMENTCHANGEENABLE
    #define FILAMENTCHANGE_XPOS 3
    #define FILAMENTCHANGE_YPOS 3
    #define FILAMENTCHANGE_ZADD 10
    #define FILAMENTCHANGE_FIRSTRETRACT -2
    #define FILAMENTCHANGE_FINALRETRACT -100
  #endif
#endif

#ifdef FILAMENTCHANGEENABLE
  #ifdef EXTRUDER_RUNOUT_PREVENT
    #error EXTRUDER_RUNOUT_PREVENT currently incompatible with FILAMENTCHANGE
  #endif
#endif

//===========================================================================
//=============================Определитель определений======================
//===========================================================================

#if defined (ENABLE_AUTO_BED_LEVELING) && defined (DELTA)
  #error "Bed Auto Leveling is still not compatible with Delta Kinematics."
#endif

#if EXTRUDERS > 1 && defined TEMP_SENSOR_1_AS_REDUNDANT
  #error "You cannot use TEMP_SENSOR_1_AS_REDUNDANT if EXTRUDERS > 1"
#endif

#if EXTRUDERS > 1 && defined HEATERS_PARALLEL
  #error "You cannot use HEATERS_PARALLEL if EXTRUDERS > 1"
#endif

#if TEMP_SENSOR_0 > 0
  #define THERMISTORHEATER_0 TEMP_SENSOR_0
  #define HEATER_0_USES_THERMISTOR
#endif
#if TEMP_SENSOR_1 > 0
  #define THERMISTORHEATER_1 TEMP_SENSOR_1
  #define HEATER_1_USES_THERMISTOR
#endif
#if TEMP_SENSOR_2 > 0
  #define THERMISTORHEATER_2 TEMP_SENSOR_2
  #define HEATER_2_USES_THERMISTOR
#endif
#if TEMP_SENSOR_BED > 0
  #define THERMISTORBED TEMP_SENSOR_BED
  #define BED_USES_THERMISTOR
#endif
#if TEMP_SENSOR_0 == -1
  #define HEATER_0_USES_AD595
#endif
#if TEMP_SENSOR_1 == -1
  #define HEATER_1_USES_AD595
#endif
#if TEMP_SENSOR_2 == -1
  #define HEATER_2_USES_AD595
#endif
#if TEMP_SENSOR_BED == -1
  #define BED_USES_AD595
#endif
#if TEMP_SENSOR_0 == -2
  #define HEATER_0_USES_MAX6675
#endif
#if TEMP_SENSOR_0 == 0
  #undef HEATER_0_MINTEMP
  #undef HEATER_0_MAXTEMP
#endif
#if TEMP_SENSOR_1 == 0
  #undef HEATER_1_MINTEMP
  #undef HEATER_1_MAXTEMP
#endif
#if TEMP_SENSOR_2 == 0
  #undef HEATER_2_MINTEMP
  #undef HEATER_2_MAXTEMP
#endif
#if TEMP_SENSOR_BED == 0
  #undef BED_MINTEMP
  #undef BED_MAXTEMP
#endif


#endif //__CONFIGURATION_ADV_H
