/* -*- c++ -*- */

/*
    Встроенное микропрограммное обеспечение Reprap на основе Спринтера и grbl.
 Copyright (C) 2011 Camiel Gubbels / Эрик ван дер Зэлм

 Эта программа - бесплатное программное обеспечение: Вы можете перераспределить 
 его и/или изменить в соответствии с Генеральной общедоступной лицензией GNU. Опубликовано
 Фондом свободного программного обеспечения.

 Эта программа поставлена в надежде, что будет полезна,
 но БЕЗ ЛЮБОЙ ГАРАНТИИ;
 Смотрите Генеральную общедоступную лицензию GNU для получения дополнительной информации.

 Вы должны были получить копию Генеральной общедоступной лицензии GNU
 вместе с этой программой. В противном случае посмотрите <http://www.gnu.org/licenses/>.
 */

/*
 Это встроенное микропрограммное обеспечение - мэшап между Спринтером и grbl.
  (https://github.com/kliment/Sprinter)
  (https://github.com/simen/grbl/tree)

 Имеется предварительная поддержка алгоритма усовершенствования Мэтью Робертса
    http://reprap.org/pipermail/reprap-dev/2011-May/003323.html
 */

/* Вся реализация сделана в *.cpp файлах, чтобы получить лучшую совместимость с avr-gcc без Arduino IDE */
/* Используйте этот файл, чтобы помочь Arduino IDE находить, какие библиотеки Arduino необходимы и сохранить документацию относительно GCode */

#include "Configuration.h"
#include "pins.h"

#ifdef ULTRA_LCD
  #if defined(LCD_I2C_TYPE_PCF8575)
    #include <Wire.h>
    #include <LiquidCrystal_I2C.h>
  #elif defined(LCD_I2C_TYPE_MCP23017) || defined(LCD_I2C_TYPE_MCP23008)
    #include <Wire.h>
    #include <LiquidTWI2.h>
  #elif defined(DOGLCD)
    #include <U8glib.h> // библиотека для графического жидкокристаллического дисплея Oli Kraus (https://code.google.com/p/u8glib/)
  #else
    #include <LiquidCrystal.h> // библиотека для символов жидкокристаллического дисплея
  #endif
#endif

#if defined(DIGIPOTSS_PIN) && DIGIPOTSS_PIN > -1
#include <SPI.h>
#endif

#if defined(DIGIPOT_I2C)
  #include <Wire.h>
#endif
